CREATE OR REPLACE PACKAGE body TBICDS.PCK_USER_CALENDAR
IS
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
/* Get all events recordset */
PROCEDURE GetAllEventsRS(
    pi_vSessionID       IN VARCHAR2,
    pi_vSessionClientIP IN VARCHAR2,
    pi_nUserID          IN NUMBER,
    rs OUT PCK_COMMON.refCursor,
    po_nStatusCode OUT NUMBER,
    po_vStatusComment OUT VARCHAR2)
is
  v_vSQL VARCHAR2(32767);
BEGIN
  -- reset status parameters
  po_nStatusCode    := 0;
  po_vStatusComment := '';
  --define sql statement string
  --open cursor
  OPEN rs FOR SELECT * FROM dev_calendar t;
EXCEPTION
WHEN OTHERS THEN
  po_nStatusCode    := 1;
  po_vStatusComment := '';
END;

/* Update event by event_id */
PROCEDURE UpdateEvent(
    pi_vSessionID       IN VARCHAR2,
    pi_vSessionClientIP IN VARCHAR2,
    pi_nUserID          IN NUMBER,
    pi_nEventID         IN NUMBER,
    pi_nCalendarID      IN NUMBER,
    pi_vTitle           IN VARCHAR2,
    pi_vStartDate       IN VARCHAR2,
    pi_vEndDate         IN VARCHAR2,
    pi_vLocation        IN VARCHAR2,
    pi_vNotes           IN VARCHAR2,
    pi_vReminder        IN VARCHAR2,
    pi_vUrl             IN VARCHAR2,
    pi_nAllDay          IN NUMBER,
    po_nStatusCode OUT NUMBER,
    po_vStatusComment OUT VARCHAR2)
is
  dtStartDate DATE := NULL;
  dtEndDate   DATE := NULL;
BEGIN
  -- reset status parameters
  po_nStatusCode          := 0;
  po_vStatusComment       := '';
  IF LENGTH(pi_vStartDate) > 0 THEN
    dtStartDate           := to_date(pi_vStartDate, 'MM/DD/YYYY HH:MI:SS AM');
  END IF;
  IF LENGTH(pi_vEndDate) > 0 THEN
    dtEndDate           := to_date(pi_vEndDate, 'MM/DD/YYYY HH:MI:SS AM');
  END IF;
  UPDATE dev_calendar t
  SET t.title      = pi_vTitle,
    t.start_date   = dtStartDate,
    t.end_date     = dtEndDate,
    t.calendar_id  = pi_nCalendarID,
    t.is_all_day   = pi_nAllDay,
    t.location     = pi_vLocation,
    t.notes        = pi_vNotes,
    t.reminder     = pi_vReminder,
    t.url          = pi_vUrl
  WHERE t.event_id = pi_nEventID;
  COMMIT;
EXCEPTION
WHEN OTHERS THEN
  po_nStatusCode    := 1;
  po_vStatusComment := '';
END;

/* Insert event */
PROCEDURE InsertEvent(
    pi_vSessionID       IN VARCHAR2,
    pi_vSessionClientIP IN VARCHAR2,
    pi_nUserID          IN NUMBER,
    --pi_nEventID         IN NUMBER,
    pi_nCalendarID      IN NUMBER,
    pi_vTitle           IN VARCHAR2,
    pi_vStartDate       IN VARCHAR2,
    pi_vEndDate         IN VARCHAR2,
    pi_vLocation        IN VARCHAR2,
    pi_vNotes           IN VARCHAR2,
    pi_vReminder        IN VARCHAR2,
    pi_vUrl             IN VARCHAR2,
    pi_nAllDay          IN NUMBER,
    po_nStatusCode OUT NUMBER,
    po_vStatusComment OUT VARCHAR2)
is
  dtStartDate DATE := NULL;
  dtEndDate   DATE := NULL;
BEGIN
  -- reset status parameters
  po_nStatusCode          := 0;
  po_vStatusComment       := '';
  IF LENGTH(pi_vStartDate) > 0 THEN
    dtStartDate           := to_date(pi_vStartDate, 'MM/DD/YYYY HH:MI:SS AM');
  END IF;
  IF LENGTH(pi_vEndDate) > 0 THEN
    dtEndDate           := to_date(pi_vEndDate, 'MM/DD/YYYY HH:MI:SS AM');
  END IF;
  INSERT
  INTO DEV_CALENDAR
    (
      CALENDAR_ID,
      END_DATE,
      IS_ALL_DAY,
      LOCATION,
      NOTES,
      REMINDER,
      START_DATE,
      TITLE,
      URL,
      PATIENT_ID,
      PROVIDER_ID
    )
    VALUES
    (
      pi_nCalendarID,
      dtEndDate,
      pi_nAllDay,
      pi_vLocation,
      pi_vNotes,
      pi_vReminder,
      dtStartDate,
      pi_vTitle,
      pi_vUrl,
      '',
      ''
    );
  COMMIT;
EXCEPTION
WHEN OTHERS THEN
  po_nStatusCode    := 1;
  po_vStatusComment := '';
END;

/* Get all calendars recordset */
PROCEDURE GetAllCalendarsRS
  (
    pi_vSessionID       IN VARCHAR2,
    pi_vSessionClientIP IN VARCHAR2,
    pi_nUserID          IN NUMBER,
    rs OUT PCK_COMMON.refCursor,
    po_nStatusCode OUT NUMBER,
    po_vStatusComment OUT VARCHAR2
  )
is
  v_vSQL VARCHAR2(32767);
BEGIN
  -- reset status parameters
  po_nStatusCode    := 0;
  po_vStatusComment := '';
  --define sql statement string
  --open cursor
  OPEN rs FOR SELECT * FROM dev_stat_calendar t WHERE t.active = 1;
EXCEPTION
WHEN OTHERS THEN
  po_nStatusCode    := 1;
  po_vStatusComment := '';
END;

END PCK_USER_CALENDAR;
/

